//
//  ViewController.swift
//  TabControllerDemo
//
//  Created by Sakib Miazi on 6/6/23.
//

import UIKit

class ViewController: UITabBarController, UITabBarControllerDelegate {

    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        
        //MARK: setting up red tab bar...
        let tabRed = UINavigationController(rootViewController: RedViewController())
        let tabRedBarItem = UITabBarItem(
            title: "Red",
            image: UIImage(systemName: "r.square")?.withRenderingMode(.alwaysOriginal),
            selectedImage: UIImage(systemName: "r.square.fill")
        )
        tabRed.tabBarItem = tabRedBarItem
        tabRed.title = "Red"
        
        //MARK: setting up green tab bar...
        let tabGreen = UINavigationController(rootViewController: GreenViewController())
        let tabGreenBarItem = UITabBarItem(
            title: "Green",
            image: UIImage(systemName: "g.square")?.withRenderingMode(.alwaysOriginal),
            selectedImage: UIImage(systemName: "g.square.fill")
        )
        tabGreen.tabBarItem = tabGreenBarItem
        tabGreen.title = "Green"
        
        //MARK: setting up blue tab bar...
        let tabBlue = UINavigationController(rootViewController: BlueViewController())
        let tabBlueBarItem = UITabBarItem(
            title: "Blue",
            image: UIImage(systemName: "b.square")?.withRenderingMode(.alwaysOriginal),
            selectedImage: UIImage(systemName: "b.square.fill")
        )
        tabBlue.tabBarItem = tabBlueBarItem
        tabBlue.title = "Blue"
        
        //MARK: setting up this view controller as the Tab Bar Controller...
        self.viewControllers = [tabRed, tabGreen, tabBlue]
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
    }
}

