import UIKit

//MARK: 9.1.2 initializers...
struct Car{
    var make:String
    var model:String
    var year:Int?
    
    init(){
        make = "Not set"
        model = "Not set"
        year = 0
    }
    
    init(make:String, model:String, year:Int) {
        self.make = make
        self.model = model
        self.year = year
    }
    
    init(make:String, model:String){
        self.make = make
        self.model = model
    }
}

//creating an instance of Car using default init...
var car = Car()

//printing the instance...
print(car)

//creating an instance of Car using the custom init()...
var car2 = Car(make: "Toyota", model: "Corolla", year: 2020)
print(car2)

var car3 = Car(make: "Honda", model: "Civic")
print(car3)
//prints: Car(make: "Honda", model: "Civic", year: nil)

//Assigning a value of year after we create the instance
car3.year = 2022
print(car3)
//prints: Car(make: "Honda", model: "Civic", year: Optional(2022))

